<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' );

$automatic_sidebar_position = '';
$automatic_sidebars_id = '';
$automatic_cat_layout ='';
$automatic_col = '';
$shop_config = automatic_settings();
if ( isset( $_GET['shop_layout'] ) ){
	$automatic_cat_layout = $_GET['shop_layout'];
}else{
	$automatic_cat_layout = $shop_config['shop_layout'];
}
if ( isset($_GET['shop_sidebar_position']) && (in_array($_GET['shop_sidebar_position'], array('left-sidebar','right-sidebar','none'))) ){
	$automatic_sidebar_position = $_GET['shop_sidebar_position'];
}else{
	$automatic_sidebar_position = $shop_config['product_categories_sidebar_position'];
}
$automatic_sidebars_id = $shop_config['product_categories_sidebar'];

if($automatic_sidebar_position == 'left-sidebar' ){
	$automatic_class_sidebar = "sidebar_left";
	$automatic_wrap_content = 'col-xs-12 col-sm-12 col-md-9 right';
}else if( $automatic_sidebar_position == 'right-sidebar' ){
	$automatic_class_sidebar = "sidebar_right";
	$automatic_wrap_content = 'col-xs-12 col-sm-12 col-md-9';
}else{
	$automatic_class_sidebar ='none';
	$automatic_wrap_content='col-xs-12 col-sm-12 col-md-12';
}
if ( isset( $_GET['shop_col'] ) ){
	$automatic_col = $_GET['shop_col'];
}else{
	$automatic_col = $shop_config['column'];
}
if ( isset( $_GET['shop_trending'] ) ){
	$automatic_trending_show = $_GET['shop_trending'];
}else{
	$automatic_trending_show = $shop_config['archive_product_trending'];
}
if ( isset( $_GET['column_subcat'] ) ){
	$column_subcat = $_GET['column_subcat'];
}else{
	$column_subcat = $shop_config['column_subcat'];
}


if($automatic_col == 2){
	$automatic_class_col = 'col-xs-12 col-md-6 col-sm-6';
}elseif($automatic_col == 3){
	$automatic_class_col = 'col-xs-12 col-md-4 col-sm-4';
}elseif($automatic_col == 4){
	$automatic_class_col = 'col-xs-12 col-md-3 col-sm-3';
}elseif($automatic_col == 5){
	$automatic_class_col = 'col-xs-15 col-md-15 col-sm-15';
}
$shop_show_breadcrum = '';
if ( isset( $shop_config['archive_product_breadcrumb'] ) ) :
	$shop_show_breadcrum = $shop_config['archive_product_breadcrumb'];
endif;
?>
<div id="primary" class="content-area">
	<main id="main" class="site-main padding-top-30 padding-bottom-70">
		<div class="container">
			<div class="row">
				<div class="<?php echo ($automatic_wrap_content); ?>">
					<?php if ( $shop_show_breadcrum == 'show' ) : ?>
						<div class="bread-crumb">
							<?php echo automatic_breadcrumbs(); ?>
						</div>
					<?php endif; ?>
					<?php
						do_action( 'woocommerce_before_main_content' );
						echo woocommerce_product_archive_description();
					?>
					<div class="shop-title">
						<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>

							<h1 class="page-title"><?php woocommerce_page_title(); ?></h1>

						<?php endif; ?>
						<?php if( ! is_product_category() ){  echo woocommerce_result_count(); } ?>
					</div>
					<?php if( is_product_category() ){ ?>
					<div class="sub-category">
						<div class="row">
							<?php automatic_woocommerce_product_subcategories( $args,$column_subcat ); ?>
						</div>
					</div>
					<?php } ?>
					<?php if ( have_posts() ) :
							$automatic_col_flag = 0;
							?>
							<div class="show-all">
								<div class="row">
									<div class="col-md-9 col-sm-9 col-xs-12">
										<ul class="list-view-as">
											<li><a href="#" id="grid1" <?php if($automatic_cat_layout == 'grid') echo 'class="active"'; ?>><i class="automaticicon-grid"></i></a></li>
											<li><a href="#" id="list1" <?php if($automatic_cat_layout =='list') echo 'class="active"'; ?>><i class="automaticicon-list"></i></a></li>
										</ul>
										<div class="soft-category">
											<a class="all" href=""><?php echo esc_html__( 'All Categories','automatic' );?></a>
											<ul class="select-cateogry">
													<?php
													$terms = get_terms( 'product_cat' );
													if(is_array($terms)){
															foreach ($terms as $term) {
																	$term_link = get_term_link( $term );
																	echo '<li><a href="' . esc_url( $term_link ) .'" title="'.$term->name.'">'.esc_attr( $term->name ).'</a></li>';
															}
													}
													?>
												</ul>
										</div>
										<div class="lt-show">
											<p class=""><?php  esc_html_e('Show','automatic'); ?></p>
											<div class="custom_select">
												<?php $automatic_perpage = get_query_var('posts_per_page');?>
												<div class="select_title"><?php echo esc_attr($automatic_perpage); ?></div>
												<ul class="select_list">
													<?php
														$automatic_current_url = $_SERVER['QUERY_STRING'];
														if(strpos($automatic_current_url,'&automatic_perpage')){
															$automatic_current_url = substr($automatic_current_url,0,strpos($automatic_current_url,'&automatic_perpage'));
														}
														$arr_num_shows = array('6','9','12','15','18','24','30');
														foreach($arr_num_shows as $arr_num_show){
																echo '<li class="tr_delay fs_medium"><a class="color_grey" href="?'. $automatic_current_url .'&automatic_perpage='. (int)$arr_num_show .'">'. (int)$arr_num_show .'</a></li>';
														}
													?>
												</ul>
											</div>
										</div>
									</div>
									<div class="col-xs-12 col-md-3 col-sm-3">
										<?php bittersweet_pagination(); ?>
									</div>
								</div>
							</div>
							<div class="products <?php if($automatic_cat_layout!='list') echo ' grid'; else echo ' list'; ?>">
								<div class="layout-grid <?php if( $automatic_cat_layout == 'grid' )  echo ' active';?>">
									<?php
										while ( have_posts() ) : the_post();
											$automatic_col_flag++;
											if ( $automatic_col_flag == 1 ) echo '<div class="row"><ul class="products-type">';
											if ( ($automatic_col_flag-1)%$automatic_col == 0 && $automatic_col_flag>$automatic_col ) echo '<div class="row"><ul class="products-type">';
												echo'<li class="'.$automatic_class_col.'">';
													wc_get_template_part( 'content', 'product_grid_layout' );
												echo '</li>';

											?>
											<?php
											if ( $automatic_col_flag == $automatic_col ) echo '</ul></div>';
											if ( $automatic_col_flag%$automatic_col == 0 && $automatic_col_flag>$automatic_col ) echo '</ul></div>';
										endwhile; // end of the loop.
										if ( $automatic_col_flag%$automatic_col != 0 ) echo '</ul></div>';
									echo '</div>';
									wp_reset_postdata();
									?>
									<div class="layout-list <?php if( $automatic_cat_layout == 'list' )  echo ' active';?>">
										<?php
										echo '<ul class="products-type">';
											while ( have_posts() ) : the_post();
												echo'<li>';
													wc_get_template_part( 'content', 'product_list_layout' );
												echo '</li>';
											endwhile; // end of the loop.
										echo '</ul>';
										wp_reset_postdata();
										?>
									</div>
								</div>
								<div class="shop-bottom">
									<?php echo woocommerce_result_count();?>

									<?php
										/**
										 * woocommerce_after_shop_loop hook.
										 *
										 * @hooked woocommerce_pagination - 10
										 */
										do_action( 'woocommerce_after_shop_loop' );
									?>
								</div>

								<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

									<?php wc_get_template( 'loop/no-products-found.php' ); ?>

								<?php endif; ?>

							<?php
								/**
								 * woocommerce_after_main_content hook.
								 *
								 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
								 */
								do_action( 'woocommerce_after_main_content' );
							?>
						<?php if( is_product_category() ){ ?>
							<?php
							if( $automatic_trending_show == 'show' && is_active_sidebar( 'shop-trending-product' ) ){ ?>
								<div class="trending-products">
									<?php dynamic_sidebar( 'shop-trending-product' );?>
								</div>
							<?php
							}
						}
						?>
				</div>
				<?php
				if( $automatic_sidebar_position != 'none' && $automatic_sidebar_position != '' ){ ?>
					<div class="col-md-3 col-xs-12 col-sm-12 shop_sidebar <?php echo ( $automatic_class_sidebar ); ?>">
						<div class="sidebar sidebarArea">
							<?php if( is_active_sidebar( $automatic_sidebars_id ) ){
								dynamic_sidebar($automatic_sidebars_id );
							} ?>
						</div>
					</div>
				<?php
					}
				?>
			</div>
		</div>
	</main>
</div>
<?php get_footer( 'shop' ); ?>
